<?php
// Busca usuários
$usuarios = [];
$result = $mysqli->query("SELECT id, nome, email FROM users ORDER BY id DESC");

if ($result && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $usuarios[] = $row;
    }
}
?>

<div class="table-wrapper">
    <div class="table-title"><h1>Usuários cadastrados<h1></div>

    <table>
        <thead>
            <tr>
                <th>Nome</th>
                <th>Email</th>
                <th style="width:80px;">Ações</th>
            </tr>
        </thead>
        <tbody>
        <?php if (!empty($usuarios)): ?>
            <?php foreach ($usuarios as $u): ?>
                <tr>
                    <td><?= htmlspecialchars($u['nome']) ?></td>
                    <td><?= htmlspecialchars($u['email']) ?></td>
                    <td>
                        <form method="post" action="excluirUsuarios.php" style="display:inline;">
                            <input type="hidden" name="id" value="<?= (int)$u['id'] ?>">
                            <button type="submit" style="border:none;background:none;color:#c00;cursor:pointer;">
                                Excluir
                            </button>
                        </form>
                    </td>
                </tr>
            <?php endforeach; ?>
        <?php else: ?>
            <tr>
                <td colspan="3">Nenhum usuário encontrado.</td>
            </tr>
        <?php endif; ?>
        </tbody>
    </table>
</div>
