console.log();

const url = 'http://temp.api.salvahof.neuroon.top/api/usuarios/v1/login.php';

const botao = document.getElementById('button-login');
const inputEmail = document.getElementById('email');
const inputSenha = document.getElementById('senha');

// mostra mensagem na tela de login
function mostrarErro(texto) {
  const divErro = document.getElementById('msg-erro');
  if (!divErro) return;
  divErro.textContent = texto;
  divErro.style.display = 'block';
}

// chama a API de login
async function login(email, senha) {
  try {
    const response = await fetch(url, {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
        'Authorization': 'Bearer NeuroOn!@*'
      },
      body: JSON.stringify({ email, senha })
    });

    let data = null;
    try {
      data = await response.json(); // tenta ler JSON, se tiver
    } catch (e) {
      data = null;
    }

    // credenciais inválidas (API responde 400)
    if (response.status === 400) {
      const msg = data && data.message ? data.message : 'Email ou senha inválidos.';
      mostrarErro(msg);
      return null;
    }

    // outros erros HTTP
    if (!response.ok) {
      mostrarErro('Erro na requisição: ' + response.status);
      return null;
    }

    console.log('Dados do usuário:', data);
    return data;
  } catch (error) {
    console.error('Erro ao fazer login:', error);
    mostrarErro('Erro de comunicação com o servidor.');
    return null;
  }
}

// clique no botão Entrar
botao.addEventListener('click', async (event) => {
  event.preventDefault();

  const email = inputEmail.value;
  const senha = inputSenha.value;

  if (!email || !senha) {
    mostrarErro('Preencha email e senha.');
    return;
  }

  const user = await login(email, senha);
  if (!user) return; // erro já exibido

  // sucesso: redireciona para o dashboard
  window.location.href = '../Dashboard/dashboard.php';
});
