<?php
session_start();
require "../config.php";

/*
if (empty($_SESSION['user_id'])) {
    header('Location: ../Login/login.php');
    exit;
}
*/

$nome = $_SESSION['user_nome'] ?? 'Usuário';
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <link rel="stylesheet" href="dashboard.css">
    <title>Painel - Salva Hof</title>
</head>
<body>

    <!-- SIDEBAR -->
    <?php include "../Sidebar/sidebar.php"; ?>

    <!-- MAIN -->
    <div class="main">

        <!-- TOPBAR -->
        <div class="topbar">
            <div>Painel de Controle</div>
            <div class="topbar-right">
                <span><?= htmlspecialchars($nome) ?></span>
                <div class="avatar"></div>
            </div>
        </div>

        <!-- CONTENT (área que será trocada) -->
        <div class="content" id="conteudo-principal">
            <h1>Visão Geral</h1>

            <div class="cards">
                <div class="card">
                    <div class="card-title">Usuários ativos</div>
                    <div class="card-value">
                        <?php
                        $stmt = $mysqli->query('SELECT COUNT(*) AS total_users FROM users');
                        if ($stmt) {
                            $row = $stmt->fetch_assoc();
                            $totalUsers = $row['total_users'] ?? 0;
                            echo $totalUsers;
                        } else {
                            echo '0';
                        }
                        ?>
                    </div>
                </div>
                <div class="card">
                    <div class="card-title">Novos hoje</div>
                    <div class="card-value">0</div>
                </div>
                <div class="card">
                    <div class="card-title">Admins</div>
                    <div class="card-value">1</div>
                </div>
            </div>

            <div class="table-wrapper">
                <div class="table-title">Últimos Usuários</div>

                <table>
                    <thead>
                        <tr>
                            <th>Nome</th>
                            <th>Email</th>
                            
                            <th></th>
                        </tr>
                    </thead>

                    <tbody>
                        <?php
                        $sql = "SELECT nome, email FROM users ORDER BY id DESC LIMIT 10";
                        $result = $mysqli->query($sql);

                        if ($result && $result->num_rows > 0):
                            while ($user = $result->fetch_assoc()):
                        ?>
                        <tr>
                            <td><?= htmlspecialchars($user['nome']) ?></td>
                            <td><?= htmlspecialchars($user['email']) ?></td>
                        </tr>
                        <?php
                            endwhile;
                        else:
                        ?>
                        <tr>
                            <td colspan="4">Nenhum usuário encontrado.</td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

        </div><!-- /content -->

    </div><!-- /main -->

    <!-- SCRIPTS -->
    <script>
    // carrega um PHP dentro da div conteudo-principal
    function carregarPagina(url) {
        fetch(url)
            .then(r => r.text())
            .then(html => {
                document.getElementById('conteudo-principal').innerHTML = html;
            })
            .catch(err => console.error('Erro ao carregar página', err));
    }

    // chamada ao clicar em "Usuários" na sidebar
    function abrirRegistroUsuarios() {
        carregarPagina('../Usuarios/registrodeUsuarios.php');
    }
    </script>

</body>
</html>
